close all;
clear all;
clc;

%Caricamento delle informazioni sulla zonizzazione
[zoneN,zoneA] = xlsread('ZoneCampionarie2013.xlsx','A2:B210');
zoneA = string(zoneA);
coordX = xlsread('ZoneCampionarie2013.xlsx','G2:G210');
coordY = xlsread('ZoneCampionarie2013.xlsx','H2:H210');

%Creazione delle matrici O/D
[ResPIEmPrIGt] = estrazionematrice('IMQ2013_MPrIGResPIE.xlsx',zoneA);
[ResPIEmPrIGsr] = estrazionematrice('IMQ2013_MPrIGResPIEsr.xlsx',zoneA);
[ResTOmPrIGt] = estrazionematrice('IMQ2013_MPrIGResTO.xlsx',zoneA);
[ResTOmPrIGsr] = estrazionematrice('IMQ2013_MPrIGResTOsr.xlsx',zoneA);
[ResPIEmPrOPt] = estrazionematrice('IMQ2013_MPrOPResPIE.xlsx',zoneA);
[ResTOmPrOPt] = estrazionematrice('IMQ2013_MPrOPResTO.xlsx',zoneA);
[ResPIEmPuIGt] = estrazionematrice('IMQ2013_MPuIGResPIE.xlsx',zoneA);
[ResPIEmPuIGsr] = estrazionematrice('IMQ2013_MPuIGResPIEsr.xlsx',zoneA);
[ResTOmPuIGt] = estrazionematrice('IMQ2013_MPuIGResTO.xlsx',zoneA);
[ResTOmPuIGsr] = estrazionematrice('IMQ2013_MPuIGResTOsr.xlsx',zoneA);
[ResPIEmPuOPt] = estrazionematrice('IMQ2013_MPuOPResPIE.xlsx',zoneA);
[ResTOmPuOPt] = estrazionematrice('IMQ2013_MPuOPResTO.xlsx',zoneA);

%Salvataggio delle matrici create nel file .mat
save IMQ2013_zonecampionarie zoneA coordX coordY ResPIEmPrIGt ResPIEmPrIGsr ResTOmPrIGt ResTOmPrIGsr ResPIEmPrOPt ResTOmPrOPt ResPIEmPuIGt ResPIEmPuIGsr ResTOmPuIGt ResTOmPuIGsr ResPIEmPuOPt ResTOmPuOPt;

%Definizione della funzione di compilazione della matrice O/D
function [matr] = estrazionematrice(nomefile,zone);
matr = zeros(length(zone),length(zone));
[SPOST,OeD] = xlsread(nomefile,'A9:E6884');
ORIG = string(OeD(:,1));
DEST = string(OeD(:,3));
for i = 1:length(SPOST);
    matr(find(zone==ORIG(i)),find(zone==DEST(i))) = SPOST(i);
end;
end














